// Copyright (c) 2010-2011 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2010.4
// 2011-02-15
//
// Validated with JSLint <http://www.jslint.com/>
//

/*global window */
/*global google */

window.document.Connect_Search_Words = '';
window.document.Connect_Search_Start_Page = '';
window.document.Connect_HandleSearchComplete = undefined;
window.document.Connect_HandleSearchLinkClick = undefined;

var search_ready = false;
var search_ready_counter = 0;

var searchID;
var searchControl;

var load = function() {
    /* Begin: callback definitions */
    /*                             */
    var onSearchStart = function(param_search_control, param_searcher, param_query) {
        // Set search words
        //
        window.document.Connect_Search_Words = param_query;
    };

    var onSearchLinkClick = function(param_event) {
        window.document.Connect_HandleSearchLinkClick(this);

        return false;
    };

    var onSearchComplete = function(param_search_control, param_searcher) {
        // Intercept search result links
        //
        var index;
        for (index = 0; index < window.document.links.length ; index++) {
            var link = window.document.links[index];

            if (link.target === 'connect_page') {
                link.onclick = onSearchLinkClick;
            }
        }

        // Track search words in Google Analytics, if enabled
        //
        if (_gaq !== undefined) {
            // Track them!
            //
            var search_uri = window.document.Connect_Search_Start_Page + '?q=' + window.document.Connect_Search_Words;
            var encoded_search_uri = encodeURI(search_uri);
            _gaq.push(['_trackPageview', encoded_search_uri]);
        }

        // Notify parent
        //
        window.document.Connect_HandleSearchComplete();
    };
    /* End: callback definitions */
    /*                           */

    // Search control settings
    //
    if (searchID !== undefined) {
        searchControl = new google.search.CustomSearchControl(searchID);
    }
    else {
        searchControl = new google.search.CustomSearchControl();
    }
    searchControl.setResultSetSize(google.search.Search.FILTERED_CSE_RESULTSET);
    searchControl.setSearchStartingCallback(this, onSearchStart);
    searchControl.setSearchCompleteCallback(this, onSearchComplete);
    searchControl.setLinkTarget('connect_page');
    //searchControl.enableAds('<Your_AdSense_Publisher_ID>');

    // Draw the control
    //
    searchControl.draw('custom-search-engine');

    // Ready to search
    //
    search_ready = true;
};

window.document.Connect_Execute_Search = function(param_query, param_start_page_href) {
    // Update search words
    //
    if (param_query !== undefined) {
        window.document.Connect_Search_Words = param_query;
    }

    // Update Search Start Page
    //
    window.document.Connect_Search_Start_Page = window.location.href;
    if (
        (param_start_page_href !== undefined)
         &&
        (param_start_page_href !== null)
         &&
        (param_start_page_href !== '')
       ) {
        window.document.Connect_Search_Start_Page = param_start_page_href;
    }

    // Ready to search?
    //
    if (search_ready) {
        // Check for a search query string and execute it
        //
        if (window.document.Connect_Search_Words !== '') {
            // Search!
            //
            searchControl.execute(window.document.Connect_Search_Words);
        }
        else {
            searchControl.clearAllResults();
        }
    }
    else {
        // Try again in a bit
        //
        if (search_ready_counter < 50) {
            search_ready_counter += 1;
            window.setTimeout(window.document.Connect_Execute_Search, 100);
        }
    }
};

google.load('search', '1');
google.setOnLoadCallback(load, true);
